### 59.8. 使用Gradle自定义配置进行Repackage

有时候不打包解析自compile，runtime和provided作用域的默认依赖可能更合适些。如果创建的可执行jar被原样运行，你需要将所有的依赖内嵌进该jar中；然而，如果目的是explode一个jar文件，并手动运行main类，你可能在CLASSPATH下已经有一些可用的库了。在这种情况下，你可以使用不同的依赖集重新打包（repackage）你的jar。

使用自定义的配置将自动禁用来自compile，runtime和provided作用域的依赖解析。自定义配置即可以定义为全局的（处于springBoot部分内），也可以定义为任务级的。
```gradle
task clientJar(type: Jar) {
    appendix = 'client'
    from sourceSets.main.output
    exclude('**/*Something*')
}

task clientBoot(type: BootRepackage, dependsOn: clientJar) {
    withJarTask = clientJar
    customConfiguration = "mycustomconfiguration"
}
```
在以上示例中，我们创建了一个新的clientJar Jar任务从你编译后的源中打包一个自定义文件集。然后我们创建一个新的clientBoot BootRepackage任务，并让它使用clientJar任务和mycustomconfiguration。
```gradle
configurations {
    mycustomconfiguration.exclude group: 'log4j'
}

dependencies {
    mycustomconfiguration configurations.runtime
}
```
在BootRepackage中引用的配置是一个正常的[Gradle配置](http://www.gradle.org/docs/current/dsl/org.gradle.api.artifacts.Configuration.html)。在上面的示例中，我们创建了一个新的名叫mycustomconfiguration的配置，指示它来自一个runtime，并排除对log4j的依赖。如果clientBoot任务被执行，重新打包的jar将含有所有来自runtime作用域的依赖，除了log4j jars。
